<?php
session_start();
include 'conexao.php';

// Redirecionar se o usuário não for um professor
$perfil = $_SESSION['usuario']['perfil'] ?? '';
if (strtoupper(trim($perfil)) !== 'PROFESSOR') {
    header('Location: login.php');
    exit;
}

// Verificar se a requisição é POST e se os dados necessários estão presentes
if ($_SERVER['REQUEST_METHOD'] !== 'POST' || !isset($_POST['aluno_id'], $_POST['disciplina_id'], $_POST['turma_id'], $_POST['trimestre'])) {
    die("Erro: Dados do formulário incompletos ou requisição inválida.");
}

$disciplina_id = (int)$_POST['disciplina_id'];
$turma_id = (int)$_POST['turma_id'];
$trimestre_selecionado = (int)$_POST['trimestre'];
$ano_lectivo = '2025/2026';

$conn->begin_transaction();

try {
    // 1. Preparar a consulta para obter as notas existentes de um aluno para TODOS os trimestres
    $sql_busca_todas = "SELECT * FROM notas WHERE aluno_id = ? AND disciplina_id = ? AND turma_id = ? AND ano_lectivo = ?";
    $stmt_busca_todas = $conn->prepare($sql_busca_todas);
    if (!$stmt_busca_todas) {
        throw new Exception("Erro na preparação do statement de busca: " . $conn->error);
    }

    // 2. Preparar a consulta para a atualização (UPSERT)
    $sql_upsert = "
        REPLACE INTO notas (
            aluno_id, turma_id, disciplina_id, ano_lectivo, trimestre, classe,
            mac, npp, npt,
            mt1, mt2, mt3,
            mfd, mf,
            neo, nee, mec, exame, nota_final
        ) VALUES (
            ?, ?, ?, ?, ?, ?,
            ?, ?, ?,
            ?, ?, ?,
            ?, ?,
            ?, ?, ?, ?, ?
        )
    ";
    $stmt_upsert = $conn->prepare($sql_upsert);
    if (!$stmt_upsert) {
        throw new Exception("Erro na preparação do statement de upsert: " . $conn->error);
    }
    
    // Obter a classe da turma uma vez
    $classe = null;
    $sql_classe = "SELECT classe FROM turmas WHERE id = ?";
    $stmt_classe = $conn->prepare($sql_classe);
    $stmt_classe->bind_param("i", $turma_id);
    $stmt_classe->execute();
    $res_classe = $stmt_classe->get_result();
    if ($res_classe->num_rows > 0) {
        $classe = $res_classe->fetch_assoc()['classe'];
    }
    $stmt_classe->close();

    foreach ($_POST['aluno_id'] as $aluno_id) {
        $aluno_id = (int)$aluno_id;

        $notas_a_salvar_por_trimestre = [
            1 => ['mac' => 0, 'npp' => 0, 'npt' => 0, 'mt' => 0],
            2 => ['mac' => 0, 'npp' => 0, 'npt' => 0, 'mt' => 0],
            3 => ['mac' => 0, 'npp' => 0, 'npt' => 0, 'mt' => 0]
        ];
        $notas_a_salvar_finais = ['mfd' => 0, 'mf' => 0, 'neo' => 0, 'nee' => 0, 'mec' => 0, 'exame' => null, 'nota_final' => null];

        $stmt_busca_todas->bind_param("iiis", $aluno_id, $disciplina_id, $turma_id, $ano_lectivo);
        $stmt_busca_todas->execute();
        $resultado_busca_todas = $stmt_busca_todas->get_result();
        
        while ($row = $resultado_busca_todas->fetch_assoc()) {
            $t_existente = (int)$row['trimestre'];
            
            if (isset($notas_a_salvar_por_trimestre[$t_existente])) {
                $notas_a_salvar_por_trimestre[$t_existente]['mac'] = (float)($row['mac'] ?? 0);
                $notas_a_salvar_por_trimestre[$t_existente]['npp'] = (float)($row['npp'] ?? 0);
                $notas_a_salvar_por_trimestre[$t_existente]['npt'] = (float)($row['npt'] ?? 0);
                $notas_a_salvar_por_trimestre[$t_existente]['mt']  = (float)($row["mt{$t_existente}"] ?? 0);
            }
            
            if ($t_existente == 3) {
                $notas_a_salvar_finais['mfd'] = (float)($row['mfd'] ?? 0);
                $notas_a_salvar_finais['mf'] = (float)($row['mf'] ?? 0);
                $notas_a_salvar_finais['neo'] = (float)($row['neo'] ?? 0);
                $notas_a_salvar_finais['nee'] = (float)($row['nee'] ?? 0);
                $notas_a_salvar_finais['mec'] = (float)($row['mec'] ?? 0);
                $notas_a_salvar_finais['exame'] = $row['exame'] !== null ? (float)$row['exame'] : null;
                $notas_a_salvar_finais['nota_final'] = $row['nota_final'] !== null ? (float)$row['nota_final'] : null;
            }
        }
        $resultado_busca_todas->free();

        // Atualizar as notas do trimestre selecionado com os novos dados do POST
        $mac = isset($_POST["mac_{$trimestre_selecionado}_{$aluno_id}"]) ? (float)$_POST["mac_{$trimestre_selecionado}_{$aluno_id}"] : 0;
        $npp = isset($_POST["npp_{$trimestre_selecionado}_{$aluno_id}"]) ? (float)$_POST["npp_{$trimestre_selecionado}_{$aluno_id}"] : 0;
        $npt = isset($_POST["npt_{$trimestre_selecionado}_{$aluno_id}"]) ? (float)$_POST["npt_{$trimestre_selecionado}_{$aluno_id}"] : 0;

        $notas_a_salvar_por_trimestre[$trimestre_selecionado]['mac'] = $mac;
        $notas_a_salvar_por_trimestre[$trimestre_selecionado]['npp'] = $npp;
        $notas_a_salvar_por_trimestre[$trimestre_selecionado]['npt'] = $npt;
        
        $mt_trimestre = ($mac + $npp + $npt) / 3;
        $notas_a_salvar_por_trimestre[$trimestre_selecionado]['mt'] = $mt_trimestre;

        if ($trimestre_selecionado == 3) {
            $neo = isset($_POST["neo_{$aluno_id}"]) ? (float)$_POST["neo_{$aluno_id}"] : 0;
            $nee = isset($_POST["nee_{$aluno_id}"]) ? (float)$_POST["nee_{$aluno_id}"] : 0;

            $mt1 = $notas_a_salvar_por_trimestre[1]['mt'];
            $mt2 = $notas_a_salvar_por_trimestre[2]['mt'];
            $mt3 = $notas_a_salvar_por_trimestre[3]['mt'];
            $mfd = ($mt1 + $mt2 + $mt3) / 3;

            $mf = 0;
            $mec = 0;
            if ($nee > 0 && $neo > 0) {
                $mec = ($neo + $nee) / 2;
                $mf = ($mfd * 0.6) + ($mec * 0.4);
            } else if ($nee > 0 && $neo === 0) {
                $mec = $nee;
                $mf = ($mfd * 0.6) + ($nee * 0.4);
            } else {
                $mec = 0;
                $mf = $mfd;
            }

            $notas_a_salvar_finais['mfd'] = $mfd;
            $notas_a_salvar_finais['mf'] = $mf;
            $notas_a_salvar_finais['neo'] = $neo;
            $notas_a_salvar_finais['nee'] = $nee;
            $notas_a_salvar_finais['mec'] = $mec;
            // Exame e Nota Final não são recalculados aqui, apenas mantidos.
        }

        // Executar o REPLACE INTO para cada trimestre
        for ($t = 1; $t <= 3; $t++) {
            $mac_t = $notas_a_salvar_por_trimestre[$t]['mac'];
            $npp_t = $notas_a_salvar_por_trimestre[$t]['npp'];
            $npt_t = $notas_a_salvar_por_trimestre[$t]['npt'];
            $mt_t = $notas_a_salvar_por_trimestre[$t]['mt'];
            
            if ($t == 3) {
                $params = [
                    $aluno_id, $turma_id, $disciplina_id, $ano_lectivo, $t, $classe,
                    $mac_t, $npp_t, $npt_t,
                    $notas_a_salvar_por_trimestre[1]['mt'],
                    $notas_a_salvar_por_trimestre[2]['mt'],
                    $notas_a_salvar_por_trimestre[3]['mt'],
                    $notas_a_salvar_finais['mfd'],
                    $notas_a_salvar_finais['mf'],
                    $notas_a_salvar_finais['neo'],
                    $notas_a_salvar_finais['nee'],
                    $notas_a_salvar_finais['mec'],
                    $notas_a_salvar_finais['exame'] ?? 0,
                    $notas_a_salvar_finais['nota_final'] ?? 0
                ];
            } else {
                $params = [
                    $aluno_id, $turma_id, $disciplina_id, $ano_lectivo, $t, $classe,
                    $mac_t, $npp_t, $npt_t,
                    $notas_a_salvar_por_trimestre[1]['mt'],
                    $notas_a_salvar_por_trimestre[2]['mt'],
                    $notas_a_salvar_por_trimestre[3]['mt'],
                    0, 0, 0, 0, 0, 0, 0
                ];
            }

            // A string de tipos de dados correta para sua consulta
            $types = "iiisiisdddddddddddd";
            $stmt_upsert->bind_param($types, ...$params);
            $stmt_upsert->execute();
        }
    }

    $conn->commit();
    $stmt_upsert->close();
    $stmt_busca_todas->close();

    // Redireciona de volta para a pauta, AGORA PARA O ARQUIVO CORRETO
    $redirect_url = "mini_pauta_professor1.php?turma_id={$turma_id}&disciplina_id={$disciplina_id}&trimestre={$trimestre_selecionado}";
    header("Location: " . $redirect_url);
    exit;

} catch (Exception $e) {
    $conn->rollback();
    die("Erro ao salvar as notas: " . $e->getMessage());
}

$conn->close();
?>